/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.trap;

import com.ibm.distman.nhd.dtp.Dtp;
import com.ibm.distman.nhd.dtp.ISnmpTrapProcessor;
import ibm.nways.jdm.SystemComponent;
import ibm.nways.jdm.snmp.SnmpTrap;
import ibm.nways.jdm.trap.TrapHandler;
import ibm.nways.jdm.trap.TrapInfo;
import ibm.nways.jdm.trap.TrapInterface;
import ibm.nways.ras.RAS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class TrapService
extends SystemComponent
implements TrapInterface,
TrapHandler {
    private static String TRAP_RECEIVER_PORT = "trapReceiverPort";
    private static String DEFAULT_TRAP_PORT = "162";
    private int servicePort = 2099;
    private String serviceName = "TrapService";
    private static TrapService singleton = null;
    private String trapDirectory = "";
    private String remoteHostName = "";
    private int remoteHostPort;
    private static int trapPort = 162;
    private static String labelsFile = "NwaysTrapLabels.txt";
    private static String rulesFile = "";
    private static String dtpHost = "softerror";
    private static String hostName = "softerror";
    private static String rmiUrl = "";
    private boolean isInitialized = false;
    private static Dtp dtp = null;
    private static TrapInterface idtp = null;

    public TrapService() throws RemoteException {
        this.componentName = this.serviceName;
        this.componentPort = this.servicePort;
        singleton = this;
    }

    public void setBaseDirectory(String string) throws RemoteException {
        this.trapDirectory = string;
    }

    public void setMaster(String string, int n) {
        this.remoteHostName = string;
        this.remoteHostPort = n;
    }

    public void run() {
        String string = SystemComponent.getComponentProperty(TRAP_RECEIVER_PORT, DEFAULT_TRAP_PORT);
        try {
            trapPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            RAS.trace(9, this, "run", "Error parsing trap receiver port number: " + string);
            RAS.trace(9, this, "run", "Using default port number " + trapPort + " instead");
        }
        try {
            RAS.trace(9, this, "run", String.valueOf(this.serviceName) + " - Creating DTP instance");
            RAS.trace(9, this, "run", String.valueOf(this.serviceName) + "     Labels file: " + labelsFile);
            dtp = new Dtp(trapPort, labelsFile);
            this.setup_dtp();
            this.read_rules();
            this.register(this.serviceName, this.servicePort, 2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static TrapInterface getManager() {
        try {
            if (singleton == null) {
                singleton = new TrapService();
                singleton.run();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return singleton;
    }

    public void test() {
        System.out.println(String.valueOf(this.serviceName) + " - executing test");
        System.out.println(String.valueOf(this.serviceName) + " - test complete");
    }

    public void setup_dtp() {
        Registry registry = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        rmiUrl = "//" + hostName + ":" + this.servicePort + "/" + "TrapService";
        try {
            registry = LocateRegistry.getRegistry(2099);
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public void read_rules() throws Exception {
        File file = new File(rulesFile);
        if (!file.exists() || !file.canRead()) {
            RAS.trace(9, this, "read_rules", "Can't read " + file);
            return;
        }
        RAS.trace(9, this, "read_rules", "opening file: " + file);
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                ++n2;
                if (string.equals("") || string.startsWith("#")) continue;
                System.out.println("line: " + string);
                try {
                    ++n;
                    dtp.addOrReplaceRule(string, (ISnmpTrapProcessor)this, null);
                }
                catch (Exception exception) {
                    System.out.println("Problem with line number: " + n2);
                    System.out.println(exception.getMessage());
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void addOrReplaceRule(String string, TrapHandler trapHandler, Object object) throws RemoteException, Exception {
        System.out.println(String.valueOf(this.serviceName) + " - Adding rule = " + string);
        dtp.addOrReplaceRule(string, (ISnmpTrapProcessor)trapHandler, object);
    }

    public void addOrReplaceRule(String string, TrapHandler trapHandler, TrapInfo trapInfo) throws RemoteException, Exception {
        System.out.println(String.valueOf(this.serviceName) + " - Adding rule = " + string);
        dtp.addOrReplaceRule(string, (ISnmpTrapProcessor)trapHandler, (Object)trapInfo);
    }

    public void deleteRule(String string) throws RemoteException {
        System.out.println(String.valueOf(this.serviceName) + " - Deleting rule ID = " + string);
        dtp.deleteRule(string);
    }

    public void processSnmpTrap(SnmpTrap snmpTrap, Object object) {
        System.out.println("I got here!" + snmpTrap.toString());
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("main:");
            TrapService trapService = new TrapService();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-help") || stringArray[n].equals("-h")) {
                    System.out.println("Usage:");
                    System.out.println("    java.ibm.nways.trap.TrapService");
                    System.out.println("Options:");
                    System.out.println("    -port    -port used to register with the RMI registry");
                    System.out.println("    -labels -fully qualified path name to file containing");
                    System.out.println("             labels for trap.                            ");
                    System.exit(0);
                } else if (stringArray[n].equals("-port")) {
                    trapService.servicePort = 2099;
                    trapPort = Integer.parseInt(stringArray[n + 1]);
                    ++n;
                } else if (stringArray[n].equals("-labels")) {
                    labelsFile = stringArray[n + 1];
                    ++n;
                } else if (stringArray[n].equals("-rules")) {
                    rulesFile = stringArray[n + 1];
                    System.out.println("main().rulesFile: " + rulesFile);
                    ++n;
                } else if (stringArray[n].equals("-basedir")) {
                    trapService.setBaseDirectory(stringArray[n + 1]);
                    ++n;
                }
                ++n;
            }
            trapService.run();
            trapService.test();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

